// $Id: i4games.js 1357 2009-11-02 13:00:48Z Yannick $

/**
 * @file
 * i4Games JavaScript Library
 */

var in_ajax = false;

$.ajaxSetup({
	global: true,
	type: "POST",
	dataType: "json"
});

// Start of AJAX operation(s)
$(document).bind("ajaxStart",function(){
	in_ajax = true;
});

// End of AJAX operation(s)
$(document).bind("ajaxStop",function(){
	in_ajax = false;
});

// AJAX error
$(document).bind("ajaxError",function(){
});

function init_facebook(key)
{
	var i = document.location.toString().split("/").length-4;
	var level = "";

	for (;i>0;i--) level = level+"../";
	if (document.location.protocol=="https")
	{
		FB.init(key,level+"xd_receiver_ssl.html");
	}
	else
	{
		FB.init(key,level+"xd_receiver.html");
	}
}

function menu_onlogin()
{
	window.location.reload();
}

function register_onlogin()
{
	document.location = '/register.php';
}

function use_fb_details()
{
	$("input[name='firstname']").val(fb_firstname).change();
	$("input[name='lastname']").val(fb_lastname).change();
	$("input[name='gender']").val([fb_gender]).change();
	$("input[name='birthdate']").val(fb_birthdate).change();
}

function action(action_url,action_params)
{
	action_params.ajax = 1;
	$.ajax({
		url: action_url,
		data: $.param(action_params),
		success: action_done
	});
}

function action_done(res)
{
	var buttons = [];

	if (res.buttons) buttons = res.buttons;
	if (res.type=="error")
	{
		show_dialog(res.caption,res.message,res.type,buttons);
	}
	else if (res.type=="message")
	{
		show_info(res.message);
	}
	else if (res.type=="output")
	{
		show_dialog(res.caption,res.output,res.type,buttons,true);
	}
}

function chr(code)
{
	if (code>=0x10000)
	{
		code -= 0x10000;
		return String.fromCharCode(0xD800+(code>>10),0xDC00+(codePt & 0x3FF));
	}
	else
	{
		return String.fromCharCode(code);
	}
}
